# The Best of Both Worlds: Toward an Honest and Helpful Large Language Model


## 📑Dataset Construction
- Our dataset is located at `HoneSet/HoneSet.json`, containing 930 entries across six categories of LLM-unable queries.
- Code for HoneSet construction is located at `dataset_construction/construction.json`, and please replace `YOUR_API_KEY` and the prompt to construct data items for each category.
- After constructing all candidate data items, please run `dataset_construction/data_filter.json` to filter and select data with cosine similarity less than threshold.

## 💡Training-Free Enhancement
- Our code for training-free enhancement method is located in `training-free/curiosity-driven.py`
- `training-free/llm_eval_honesty_rate.py` is the code for evaluate honesty rate using GPT-4.
- `training-free/embedding.py` is the code which process question data using a pre-trained language model and save the hidden states to secure tensor files for analysis.

##  ✨Improvement Through Fine-Tuning
- Our code for two-stage fine-tuning process using LLaMA-Factory is located in `fine-tuning\llama-factory yaml`.
- Training dataset for two-stage fine-tuning with different threshold is located in `fine-tuning\DPO_training_dataset`.

## 🔍Requirements
- openai 1.x
- replicate
- tenacity
- torch
- pynvml
- transformers